<?php

namespace App\Models\Students;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getStudents()
    {
        return $this->belongsToMany('Student', 'student_group');
    }

    public function getOwnerStudent()
    {
        return $this->belongsTo('Student', 'owner_student_id');
    }

    public function getOwnerUser()
    {
        return $this->belongsTo('User', 'owner_user_id');
    }

}